package com.sensetime.uc.proxy;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.Map;

@RestController
@RequestMapping("/ucproxy/api")
public class UCProxyController {

    @Autowired
    private ApiService apiService;

    @Value("${from.token}")
    private String fromToken;

    @GetMapping("/token")
    public ResponseEntity<?> getToken(@RequestParam(name = "from") String from) {
        try {
            if(!fromToken.equals(from)){
                return ResponseEntity.ok("Auth Fail!");
            }
            ResultData<UserTokenResultResponseDTO> token = apiService.getAccessToken();
            return ResponseEntity.ok(token);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.internalServerError().body("Error generating token");
        }
    }

    @GetMapping("/cache")
    public ResponseEntity<?> getCache() {
        try {
            Map cache = apiService.getCache();
            return ResponseEntity.ok(cache);
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.internalServerError().body("Error generating token");
        }
    }

    @GetMapping("/cache/clear")
    public ResponseEntity<?> clearCache() {
        try {
            apiService.clearCache();
            return ResponseEntity.ok("success");
        } catch (Exception e) {
            e.printStackTrace();
            return ResponseEntity.internalServerError().body("Error generating token");
        }
    }
}
