# 互动数字人H5-DEMO

**注意：因为使用麦克风等接口，所以协议必须为合法https协议。**

### 项目启动

#### 安装依赖
```js
npm install
```

#### 获取用户唯一标识
本项目需要用户登录后方可使用，登录代码在`src/requests/login.ts`中。项目开发者需要将`requestId`替换为用户中心代理服务的相关`用户唯一标识`。拿到标识后直接修改`config/account.json`中的`requestId`字段即可。

#### 启动项目
```js
npm run dev
```

#### 访问
> 默认端口是5173, 访问 http://localhost:5173/h5/


### 项目说明

>  项目基于vite + vue3 构建。

项目目录说明：

```
src
 ┣ assets             // 静态资源
 ┃ ┗ images           // 图片资源
 ┣ components         // 组件
 ┃ ┣ Chat.vue         // 聊天组件
 ┃ ┣ ChatList.vue     // 聊天列表组件
 ┃ ┣ MediaBg.vue      // 媒体组件：图片/视频
 ┣ requests           // http请求模块
 ┃ ┗ login.ts         // 登录请求 + 刷新token请求
 ┣ utils              // 拓展工具
 ┃ ┣ common.ts        // 公用方法
 ┃ ┣ http.ts          // axios封装
 ┃ ┗ md5.js           // md5算法
 ┣ views              // 视图 / 页面
 ┃ ┣ Home.vue         // 首页
 ┃ ┣ Live.vue         // 直播模块，内嵌首页
 ┃ ┣ Setting.vue      // 设置页
 ┃ ┗ Video.vue        // 教学视频页
 ┣ App.vue            // 全局框架
 ┣ main.ts            // 项目入口
 ┣ router.ts          // 全局路有
 ┣ store.ts           // 全局状态
 ┣ style.css          // 全局样式
 ┗ vite-env.d.ts      // 全局类型定义
config                // 数据配置(本地开发)
 ┣ account.json       // 账号及全局数据配置
 ┗ roles.json	        // 角色列表配置
```


### 单个角色json说明

```json
{
    "name": "小M床",	// 人物名称，必填
    "info": "艺术生，刚毕业，身材好", // 人物介绍，必填
    "welcome": "你好，我是小M床", // 加载欢迎语，必填
    "thumbnail": "video.webm", // 预览图/视频，必填，建议5M以下，视频建议webm格式
    "json": {},	// 直播脚本json，必填，参考文档
    "asr": {},	// asr配置，可选，默认是ASR5，详细配置参考文档
    "nlp": {}, // nlp配置，必填， 详细配置参考文档
    "extra": {	// 口水话和打断逻辑配置，可选，内部所有参数都可选，下面是默认值
      "quick_response_enable": true, // 是否开启口水话
      "quick_response_random": true, // 随机播报口水话
      "quick_response_delay": 1000, // 播报口水话触发时间，单位毫秒
      "command_immediate": true // 是否立即接管
    }
}
```

