
import axios from '../utils/http';
// @ts-ignore
import md5 from '../utils/md5';
import { showToast } from 'vant';

const UpdateTokenTime = 1 * 60 * 60 * 1000;
export const KeyToken = 'aigc-token';

interface LoginResProps {
  accessToken: string;
}

// 登录
export default async function login(client: SenseAigc, requestId: string) {
  try {
    const loginRes: LoginResProps = await axios.get(`/ucproxy/api/token?from=${requestId}`);
    const { accessToken } = loginRes;
    
    sessionStorage.setItem(KeyToken, accessToken);
    client.setToken(accessToken);

    setTimeout(async() => {
      await login(client, requestId);
    }, UpdateTokenTime);

  } catch(e: any) {
    showToast({
      type: 'fail',
      message: e.message
    });
  }
}