// router/index.js
import { createRouter, createWebHashHistory } from 'vue-router'

const routes = [
  {
    path: '/',
    name: 'Home',
    component: () => import('./views/Home.vue'),
    meta: {
      title: '语音对话数字人'
    }
  },
  {
    path: '/setting',
    name: 'Setting',
    component: () => import('./views/Setting.vue'),
    meta: {
      title: '设置'
    }
  },
  {
    path: '/video',
    name: 'video',
    component: () => import('./views/Video.vue'),
    meta: {
      title: '教学视频'
    }
  },
  {
    path: '/:pathMatch(.*)*',
    redirect: '/'
  }
]

const router = createRouter({ history: createWebHashHistory(), routes })

router.afterEach((to: any) => {
  document.title = to.meta.title;
});

export default router