// src/store.js
import { showToast } from 'vant';
import { reactive } from 'vue';

export const liveClient = reactive({
  client: null,
  instant: false,
  changeInstant(instant: boolean) {
    this.instant = instant;
  }
});

export const chatState: ChatStateProps = reactive({
  list: [] as ChatProps[],
  end: true as boolean,
  isCommandEnd: true as boolean,
  startCommand() {
    this.isCommandEnd = false;
  },
  endCommand() {
    this.isCommandEnd = true;
  },
  handleChat(chat: ChatProps) {
    console.log(chat)
    if (chat.service === 'record' && chat.type === 'eof') {
      this.startCommand();
      return;
    }

    if (chat.service === 'command' && chat.type === 'eof') {
      this.endCommand();
      return;
    }

    if (chat.status === 'fail') {
      this.endCommand();
      this.end = true;
      if (chat.error) {
        const errorDict: {
          [k: string]: string
        } = {
          'query is empty': '麦克风没有识别到信息，请重新发送',
          'nlp server unexcepted disconnect': 'NLP 服务异常断开'
        }

        const text: string = errorDict[chat.error] || `异常: ${chat.error}`;
        showToast(text);
        return;
      }

      showToast(chat.error);
      
      return;
    }

    this.add(chat);
  },
  add(chat: ChatProps) {
    if ((chat.type === 'intermediate' || chat.type === 'text' || chat.type === 'partial_answer') && chat.status !== 'fail') {
      this.end = false;
    } else {
      this.end = true;
    }

    if (chat.service === 'asr' && chat.query === "") return;
    if (chat.service === 'nlp' && chat.answer === "" && chat.type !== "eof") {
      showToast('NLP 应答为空');
      this.endCommand();
      return;
    }

    const getText = (cc: ChatProps): string => {
      if (cc.service === 'opening') {
        return cc.text;
      }
      if (cc.service === 'asr') {
        return cc.query || '';
      }

      return cc.answer || '';
    }

    let existingChat: ChatProps | undefined = this.list.find((item: ChatProps) => item.trace === chat.trace && item.service === chat.service);
    
    if (existingChat) {
      existingChat.text += getText(chat);
      return;
    }

    this.list.push({
      ...chat,
      text: getText(chat)
    });
  },
  clear() {
    this.list = [];
  }
})
