import axios from 'axios';
import { KeyToken } from '../requests/login';

const service = axios.create({
  baseURL: localStorage.getItem('aigc-base_url') || '/',
  withCredentials: true,
  timeout: 70000,
});

interface ResponseProps {
  code: number;
  message: string;
  data: any;
}

service.interceptors.request.use(
  (config: any) => {
    config.headers.Authorization = `Bearer ${sessionStorage.getItem(KeyToken)}`
    return config;
  },
  (error: any) => {
    return Promise.reject(error);
  }
);

service.interceptors.response.use(
  (response: { data: ResponseProps; status: number; statusText: string; }): Promise<any> => {
    if (response.status && response.status !== 200) {
      return Promise.reject(response.statusText);
    }

    const res: ResponseProps = response.data;

    const { code, data, message } = res;

    if (code !== 0) {
      throw new Error(message);
    }

    return Promise.resolve(data);
  },
  (error: any) => {
    return Promise.reject(error);
  }
);

export default service;