/// <reference types="vite/client" />

interface ChatProps {
  service: "opening" | "nlp" | "asr" | "command" | "record";
  id: string | number;
  trace: string;
  index?: number;
  text: string;
  type: "eof" | "answer" | "partial_answer" | "text" | "intermediate";
  query?: string;
  answer?: string;
  error?: string;
  status: 'ok' | 'fail';
}

interface RoleProps {
  name: string;
  info: string;
  welcome: string;
  json: Object;
  thumbnail: string;
  nlp: NLPConfProps;
  extra: any;
}

interface ChatStateProps {
  list: ChatProps[];
  end: boolean;
  isCommandEnd: boolean;
  add(chat: ChatProps): void;
  clear(): void;
  startCommand(): void;
  endCommand(): void;
  handleChat(chat: ChatProps): void;
}

interface LiveClientProps {
  instant: boolean;
  changeInstance(arg: boolean): void;
}

interface ConfigProps {
  baseUrl: string;
  logLevel?: number;
}

interface CustomProps {
  urtcToken: string;
  urtcUid: string;
  urtcAppId: string;
  urtcChannelId: string;
  userData?: string;
}

interface CreateLiveExtraProps {
  quick_response_random?: boolean;
  quick_response_delay?: number;
  command_immediate?: boolean;
}

interface ASRConfProps {
  type: string;
  config?: {
    [_:string]: string
  };
}

interface NLPConfProps {
  type: string;
  model: string;
  stream: boolean;
  max_reply_token: number;
  prompt_header: string;
}

interface CreateLiveProps {
  data: string;
  nlp: NLPConfProps;
  container?: HTMLElement;
  asr?: ASRConfProps;
  extra?: CreateLiveExtraProps;
  onmessage?: Function;
  custom?: CustomProps;
  autoPlay?: boolean;
  onstream?: Function;
  onnetworkchange?: Function;
}

interface SenseLive {
  start(container?: HTMLElement): Promise<void>;
  close(): Promise<void>;
  startAsk(): Promise<void>;
  stopAsk(): Promise<void>;
}

interface SenseAigc {
  constructor(config: ConfigProps);
  setToken(token: string): void;
  quickBoot(config: CreateLiveProps): Promise<SenseLive>;
  create(params: CreateLiveProps): Promise<SenseLive>;
  leave(): void;
}
